(function () {
  const url = "https://cdn.jsdelivr.net/gh/katelyynn/bleh/fm/bleh.user.js";
  const cssUrl = "https://cdn.jsdelivr.net/gh/katelyynn/bleh/fm/bleh.css";

  window.unsafeWindow = window;

  const overlay = document.createElement("div");
  overlay.id = "bleh-loader";
  Object.assign(overlay.style, {
    position: "fixed",
    inset: "0",
    background: "#000",
    color: "#fff",
    display: "flex",
    justifyContent: "center",
    alignItems: "center",
    fontSize: "2em",
    fontFamily: "sans-serif",
    zIndex: "999999",
  });
  overlay.textContent = "Loading bleh...";
  document.documentElement.appendChild(overlay);

  document.documentElement.style.visibility = "hidden";
  overlay.style.visibility = "visible";

  // Load CSS
  const link = document.createElement("link");
  link.rel = "stylesheet";
  link.href = cssUrl;
  link.crossOrigin = "anonymous";
  document.head.appendChild(link);

  // Load JS
  const script = document.createElement("script");
  script.src = url;
  script.async = false;
  script.crossOrigin = "anonymous";

  const done = () => {
    document.documentElement.style.visibility = "visible";
    overlay.remove();
  };

  script.onload = () => {
    console.log("Loaded:", url);
    done();
  };
  script.onerror = (e) => {
    console.error("Failed to load bleh:", e);
    overlay.textContent = "Failed to load bleh.";
    setTimeout(done, 2500);
  };

  document.head.appendChild(script);
})();
