---@class InnerRemote
---@field port number
---@field password string

---@class ConectionRemote : InnerRemote
---@field remote string

---@class Remote
---@field ender_storage string
---@field modem string
---@field remotes table<string, InnerRemote>|nil
---@field connection InnerRemote|nil

---@class Chatbox
---@field players table<string, string>
---@field prefix string|nil

---@class Config
---@field inventories string[]|nil
---@field import string[]|nil
---@field chatbox Chatbox|nil
---@field remote Remote|nil

local config = require("../config") ---@type Config

local inv = require("modules.inv")
local ui = require("modules.ui")
local chatbox = require("modules.chatbox")
local ra = require("modules.ra")


local function importMechanism()
  if config.import == nil then
    return
  end
  if #config.import == 0 then
    return
  end

  while true do
    for _, import_from_inv in ipairs(config.import) do
      ---@type ccTweaked.peripheral.Inventory
      local perip = peripheral.wrap(import_from_inv)
      if perip and perip.size then
        local slotsToSend = {}
        for slot = 1, perip.size() do
          local item = perip.getItemDetail(slot)
          if item then
            table.insert(slotsToSend, slot)
          end
        end
        if #slotsToSend > 0 then
          -- for some reason if i set perip here it takes like 9000 more decades , weird
          print(inv:sendItemAwayMultiple(slotsToSend, nil, import_from_inv))
        end
      end
    end
    sleep(0.1)
  end
end

inv:sync()
parallel.waitForAll(inv:run(), chatbox.run, ra.run,
  ui.run,
  importMechanism, function() inv:detectPlayerInsert() end)
