local inv = require("modules.inv")

local PrimeUI = require("lib.primeui").PrimeUI;
local function is_beta(ver)
  if ver:match("^[0-9a-f]+$") and #ver >= 8 then
    return false
  end
  return true
end

local function run()
  local search = ""
  local win = term.current();
  local w, h = term.getSize()

  local items = inv:listItemAmounts()
  local x = 0

  local function getFiltered()
    local filtered = {}

    x = x + 1
    if x % 3 == 0 then
      items = inv:listItemAmounts()
    end

    for name, count in pairs(items) do
      if search == "" or string.find(name:lower(), search:lower(), 1, true) then
        table.insert(filtered, { name = name, count = count })
      end
    end
    table.sort(filtered, function(a, b) return a.count > b.count end)

    local refiltered = {}

    for i, filter in ipairs(filtered) do
      refiltered[i] = filter.name ..
          string.rep(" ", w - (2 + #filter.name + #tostring(filter.count))) .. tostring(filter.count)
    end
    return refiltered
  end

  local com = getFiltered()

  PrimeUI.clear()
  local updateEntries = PrimeUI.selectionBox(
    win, 1, 4, w, h - 7,
    function()
      return com
    end,
    function(option, key)
      if not option then return end

      if key == keys.enter then
        local z = option:match("^(%S+)")
        if inv:getItem(z) then
          inv:sendItemToSelf(z)
        end
      end
    end
  )

  PrimeUI.inputBox(win, 2, 2, w - 2, function(data)
    search = data
    com = getFiltered()
    updateEntries()
  end, "Input a item to search..")

  local ver = fs.open("storage-solution/version", "r").readAll()

  PrimeUI.label(win, 2, h - 1, is_beta(ver) and "you're running beta :3" or "welcome to SiSS", colors.lightGray)
  PrimeUI.label(win, 2, h - 2, "rev. " .. ver, colors.lightGray)

  local timer = os.startTimer(1)
  PrimeUI.addTask(function()
    while true do
      local _, osTimer = os.pullEvent("timer")
      if osTimer == timer then
        com = getFiltered()
        updateEntries()
        timer = os.startTimer(1)
      end
    end
  end)

  PrimeUI.addTask(function()
    while true do
      local _, osTimer = os.pullEvent("timer")
      if osTimer == timer then
        com = getFiltered()
        updateEntries()
        timer = os.startTimer(1)
      end
    end
  end)

  PrimeUI.run()
end


return {
  run = run
}
