---@class InventoryLayerHopper : InventoryBase
local Base = require("modules.inventory.base")

---@class InventoryLayerHopper : InventoryBase
local Hopper = setmetatable({}, Base)
Hopper.__index = Hopper

local config = require("../../config")

---@class HopperLib
---@field list fun(mode:string):table<string, integer>
---@overload fun(cmd:string):integer
local hopper = require("lib.hopper")

---@return InventoryLayerHopper
function Hopper:new()
  ---@type InventoryLayerHopper
  local o = Base.new(self)

  ---@type string
  o.patterns = table.concat(config.inventories or {}, "|")

  return o
end

function Hopper:sync()
  print("syncing hopper")
  hopper("-scan-threads 16 -storage store " .. self.patterns)
  print("synced")
end

---@return fun()
function Hopper:run()
  return function() end
end

---@param itemName string
---@param perip ccTweaked.peripheral.Inventory|string|nil
---@param maxAmount integer|nil
---@param id string|nil
---@return integer
function Hopper:sendItemToSelf(itemName, perip, maxAmount, id)
  return self:_withMoveLock(function()
    return hopper(
      "store self "
      .. itemName
      .. " -transfer-limit "
      .. tostring(maxAmount or 64)
    )
  end) or 0
end

---@param slots TurtleSlot[]
---@param perip ccTweaked.peripheral.Inventory|nil
---@param id string|nil
---@param maxAmount integer|nil
---@return integer
function Hopper:sendItemAwayMultiple(slots, perip, id, maxAmount)
  local hopslots = ""

  for _, slot in ipairs(slots) do
    hopslots = hopslots .. " -from-slot " .. tostring(slot)
  end

  return hopper(
    "self store -from-limit-max "
    .. tostring(maxAmount or 64)
    .. hopslots
    .. " -per-slot"
  ) or 0
end

---@return table<string, integer>
function Hopper:listItemAmounts()
  return hopper.list("store") or {}
end

---@return string[]
function Hopper:listNames()
  ---@type string[]
  local out = {}

  for name in pairs(self:listItemAmounts()) do
    table.insert(out, name)
  end

  return out
end

---@param name string
---@return table
function Hopper:getItem(name)
  -- Hopper cannot query single items precisely
  return {}
end

---@return InventoryLayerHopper
return function()
  return Hopper:new()
end
